% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grpoutputs.R
\name{plot.grpoutputs}
\alias{plot.grpoutputs}
\title{Plot grouped outputs}
\usage{
\method{plot}{grpoutputs}(x, ...)
}
\arguments{
\item{x}{Object of class \code{grpoutputs}.}

\item{...}{Extra options passed to \code{\link[graphics]{plot.default}}.}
}
\value{
None.
}
\description{
Plot objects of class \code{grpoutputs}.
}
\details{
Each output is plotted individually, and observations are plotted on top of
each other. Observations from different groups are plotted with different
colors (which can be controlled through the \code{col} parameter given in
...).

This function can be very slow for a large number of observations.
}
\examples{
# Determine paths for the data folder containing outputs of different
# lengths
dir_na <- system.file("extdata", "testdata", "NA", package = "micompr")

# Sets of files A and B have 3 files each
filesA <- glob2rx("stats400v1*n20A.tsv")
filesB <- glob2rx("stats400v1*n20B.tsv")

# Instantiate grpoutputs object
go <-
 grpoutputs(7, dir_na, c(filesA, filesB), lvls = c("A", "B"), concat = TRUE)

# Plot grpoutputs object
plot(go)

}
