% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addIterations.R
\name{addIterations}
\alias{addIterations}
\title{addIterations}
\usage{
addIterations(miceObj, iters = 5, parallel = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{miceObj}{A miceDefs object created by \code{miceRanger}.}

\item{iters}{The number of iterations to add to each dataset.}

\item{parallel}{Should the process run in parallel? This process will take advantage of any cluster 
set up when \code{miceRanger} is called.}

\item{verbose}{should progress be printed?}

\item{...}{other parameters passed to \code{ranger()} to control model building.}
}
\value{
an updated miceDefs object with additional iterations.
}
\description{
Add iterations to a current miceDefs object. Adds iterations for all datasets.
}
\examples{
data("sampleMiceDefs")
miceObj <- addIterations(
    sampleMiceDefs
  , iters=2
  , verbose=FALSE
  , num.threads = 1
  , num.trees=5
)
}
