% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrPermutationTests.R
\name{discr.test.one_sample}
\alias{discr.test.one_sample}
\title{Discriminability One Sample Permutation Test}
\usage{
discr.test.one_sample(
  X,
  Y,
  is.dist = FALSE,
  dist.xfm = mgc.distance,
  dist.params = list(method = "euclidean"),
  dist.return = NULL,
  remove.isolates = TRUE,
  nperm = 500,
  no_cores = 1
)
}
\arguments{
\item{X}{is interpreted as:
\describe{
   \item{a \code{[n x d]} data matrix}{X is a data matrix with \code{n} samples in \code{d} dimensions, if flag \code{is.dist=FALSE}.}
   \item{a \code{[n x n]} distance matrix}{X is a distance matrix. Use flag \code{is.dist=TRUE}.}
}}

\item{Y}{\code{[n]} a vector containing the sample ids for our \code{n} samples.}

\item{is.dist}{a boolean indicating whether your \code{X} input is a distance matrix or not. Defaults to \code{FALSE}.}

\item{dist.xfm}{if \code{is.dist == FALSE}, a distance function to transform \code{X}. If a distance function is passed,
it should accept an \code{[n x d]} matrix of \code{n} samples in \code{d} dimensions and return a \code{[n x n]} distance matrix
as the \code{$D} return argument. See \link[mgc]{mgc.distance} for details.}

\item{dist.params}{a list of trailing arguments to pass to the distance function specified in \code{dist.xfm}.
Defaults to \code{list(method='euclidean')}.}

\item{dist.return}{the return argument for the specified \code{dist.xfm} containing the distance matrix. Defaults to \code{FALSE}.
\describe{
    \item{\code{is.null(dist.return)}}{use the return argument directly from \code{dist.xfm} as the distance matrix. Should be a \code{[n x n]} matrix.}
    \item{\code{is.character(dist.return) | is.integer(dist.return)}}{use \code{dist.xfm[[dist.return]]} as the distance matrix. Should be a \code{[n x n]} matrix.}
}}

\item{remove.isolates}{remove isolated samples from the dataset. Isolated samples are samples with only
one instance of their class appearing in the \code{Y} vector. Defaults to \code{TRUE}.}

\item{nperm}{the number of permutations to perform. Defaults to \code{500}.}

\item{no_cores}{the number of cores to use for permutation test. Defaults to \code{1}.}
}
\value{
A list containing the following:
\item{\code{stat}}{the discriminability of the data.}
\item{\code{null}}{the discriminability scores under the null, computed via permutation.}
\item{\code{p.value}}{the pvalue associated with the permutation test.}
}
\description{
A function that performs a one-sample test for whether the discriminability differs from random chance.
}
\section{Details}{


Performs a test of whether an observed discriminability is significantly different from chance, as described in Bridgeford et al. (2019).
With \eqn{\hat D_X}{Dhatx} the sample discriminability of \eqn{X}{X}:
\deqn{H_0: D_X = D_0}{H0: Dx = D0} and:\deqn{H_A: D_X > D_0}{Ha: Dx > D0} where \eqn{D_0}{D0}
is the discriminability that would be observed by random chance.
}

\examples{
\dontrun{
require(mgc)
n = 100; d=5

# simulation with a large difference between the classes
# meaning they are more discriminable
sim <- discr.sims.linear(n=n, d=d, K=2, signal.lshift=10)
X <- sim$X; Y <- sim$Y

# p-value is small
discr.test.one_sample(X, Y)$p.value
}
}
\references{
Eric W. Bridgeford, et al. "Optimal Decisions for Reference Pipelines and Datasets: Applications in Connectomics." Bioarxiv (2019).
}
\author{
Eric Bridgeford
}
