% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{discr.sims.radial}
\alias{discr.sims.radial}
\title{Discriminability Radial Simulation}
\usage{
discr.sims.radial(
  n,
  d,
  K,
  er.scale = 0.1,
  r = 1,
  class.equal = TRUE,
  ind = FALSE
)
}
\arguments{
\item{n}{the number of samples.}

\item{d}{the number of dimensions.}

\item{K}{the number of classes in the dataset.}

\item{er.scale}{the scaling for the error of the samples. Defaults to \code{0.1}.}

\item{r}{the radial spacing between each class. Defaults to \code{1}.}

\item{class.equal}{whether the number of samples/class should be equal, with each
class having a prior of 1/K, or inequal, in which each class obtains a prior
of k/sum(K) for k=1:K. Defaults to \code{TRUE}.}

\item{ind}{whether to sample x and y independently. Defaults to \code{FALSE}.}
}
\description{
A function to simulate data with the same mean with radial symmetry as class id increases.
}
\examples{
library(mgc)
sim <- discr.sims.radial(100, 3, 2)
}
\author{
Eric Bridgeford
}
