% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sipd.meteDist.R
\name{sipd}
\alias{sipd}
\alias{sipd.meteESF}
\title{Generic method to obtain the species-level individual power distribution (SIPD)}
\usage{
sipd(x, ...)

\method{sipd}{meteESF}(x, sppID, n, ...)
}
\arguments{
\item{x}{An object of class meteESF (i.e. the fitted distribution \eqn{R(n,e)})}

\item{...}{arguments to be passed to methods}

\item{sppID}{the name or index of the species of interest as listed in the \code{spp} argument passed to \code{meteESF}}

\item{n}{integer. Alternatively can extract METE prediction by indicating number of individuals in the species}
}
\value{
An object of class \code{meteDist}. The object contains a list with the following elements.
\describe{
  \item{data}{The data used to construct the prediction}
  \item{d}{density funciton}
  \item{p}{cumulative density function}
  \item{q}{quantile funtion}
  \item{r}{random number generator}
  \item{La}{Vector of Lagrange multipliers}
  \item{state.var}{State variables used to constrain entropy maximization}
  \item{type}{Specifies the type of distribution is 'sad'}
}
}
\description{
Extract species level individual power distribution
from ESF object and return object inheriting from meteDist. This distribution (Theta) describes the distribution of metabolic rates across the individuals of a species with n individuls
}
\details{
If \code{n} is provided then only the theoretical prediction is returned (because
data from multiple species could map to the same n). Thus if data and prediction are
desired use \code{sppID}.
}
\examples{
data(arth)
esf1 <- meteESF(spp=arth$spp,
                abund=arth$count,
                power=arth$mass^(.75),
                minE=min(arth$mass^(.75)))
sipd1 <- sipd(esf1, sppID=5)
sipd1
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
sad.meteESF, ipd.meteESF, metePsi

Other Theta: \code{\link{meteTheta}}
}

