% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ipd.meteESF.R
\name{ipd}
\alias{ipd}
\alias{ipd.meteESF}
\title{Individual Power Distribution}
\usage{
ipd(x, ...)

\method{ipd}{meteESF}(x, ...)
}
\arguments{
\item{x}{an object of class meteESF.}

\item{...}{additiona arguments to be passed to methods}
}
\value{
An object of class \code{meteDist}. The object contains a list with the following elements.
\describe{
  \item{data}{The data used to construct the prediction}
  \item{d}{density funciton}
  \item{p}{cumulative density function}
  \item{q}{quantile funtion}
  \item{r}{random number generator}
  \item{La}{Vector of Lagrange multipliers}
  \item{state.var}{State variables used to constrain entropy maximization}
  \item{type}{Specifies the type of distribution is 'sad'}
}
}
\description{
\code{ipd.meteESF} calculates the distribution Psi(e | N0, S0, E0),
the distribution of metabolic rates across all individuals in a commmunity
}
\details{
See examples.
}
\examples{
data(arth)
esf1 <- meteESF(spp=arth$spp,
               abund=arth$count,
               power=arth$mass^(.75),
               minE=min(arth$mass^(.75)))
ipd1 <- ipd(esf1)
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
meteDist, sad.meteESF, metePsi
}
\keyword{METE,}
\keyword{MaxEnt,}
\keyword{ecosystem}
\keyword{function}
\keyword{lagrange}
\keyword{multiplier,}
\keyword{structure}

