% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.limitmeta.R
\name{summary.limitmeta}
\alias{summary.limitmeta}
\title{Summary method for limit meta-analysis}
\usage{
\method{summary}{limitmeta}(object, ...)
}
\arguments{
\item{object}{An object of class \code{limitmeta}.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
This function returns the same list as the function
  \code{limitmeta}, however class "summary.limitmeta" is added to
  the object in order to print a detailed summary of the limit
  meta-analysis object.
}
\description{
Summary method for objects of class \code{limitmeta}.
}
\examples{
data(Moore1998)
m1 <- metabin(succ.e, nobs.e, succ.c, nobs.c,
  data = Moore1998, sm = "OR", method = "Inverse")

summary(limitmeta(m1))

}
\seealso{
\code{\link{limitmeta}}, \code{\link{funnel.limitmeta}},
  \code{\link{print.summary.limitmeta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
