% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_plot_fulltaxo.R
\name{plot_fulltaxo}
\alias{plot_fulltaxo}
\title{plot_fulltaxo}
\usage{
plot_fulltaxo(spectral_count_object, force = FALSE)
}
\arguments{
\item{spectral_count_object}{List defined as "spectral_count_object" 
containing dataframes with format similar to that generated with 
the function "getsc_specific".  This object contains abundances 
expressed as spectral counts from peptides, subgroups (metaproteins) 
or groups. Taxonomy must have previously been added with the function 
"add_taxonomy".}

\item{force}{Logic value set at FALSE by default in order to ask 
permission to create a pdf and a csv file in the workstation of 
the user.}
}
\value{
Bar plots (pdf) and csv file with the number of taxonomic species, 
   genus, family, order, class, phylum and superkingdom per sample. 
   An additional csv file is generated providing the rate of assignment. 
   The rate of assigment corresponds to the ratio between the number of 
   the most frequent annotation ("species", "genus", "family", "order", 
   "class", "phylum" or "superkingdom") and the total number of elements within 
   each level of the spectral category under study (subgroup or group).
   The csv file is generated only when the "spectral_count_object" is 
   organized by subgroup or by group.
}
\description{
Provides the number of taxonomic entities per sample in the different 
taxonomic levels. The taxonomic levels are: species, genus, family, order, 
class, phylum and superkingdom.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(fecal_waters)
plot_fulltaxo(fecal_waters)

\dontshow{setwd(.old_wd)}
}
