% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_getsc_specific.R
\name{getsc_specific}
\alias{getsc_specific}
\title{getsc_specific}
\usage{
getsc_specific(metaproteome_object, type_SCspecific)
}
\arguments{
\item{metaproteome_object}{List defined as "metaproteome_object" with 
dataframes having a similar format to that generated from 
"load_protspeps" function. It contains metaproteomics 
data such as peptide and protein abundances and sample 
information.}

\item{type_SCspecific}{Character indicating the type of data 
to be returned. The possible options are: i) "sc_specific_peptides" 
for peptides, or ii) "sc_groups" for groups, or iii) "sc_subgroups" 
for subgroups. For more details of the identification algorithm 
(peptides, subgroups, groups) check 
\href{http://pappso.inrae.fr/bioinfo/xtandempipeline/}{X!TandemPipeline}.}
}
\value{
A list of four elements defined as "spectral_count_object". The first 
   element is a dataframe organized in function of peptides OR subgroups 
   (also referred as metaproteins) OR groups. The entities of this dataframe 
   have their abundance expressed as SC from specific peptides. The second 
   element is a dataframe of metadata containing the experiment information. 
   The third element is a dataframe containing the information of peptides 
   with their associated proteins. The fourth element is a character 
   indicating the type of object generated.
}
\description{
Returns the abundances, expressed as spectral counts (SC), of the different 
peptides, subgroups (also referred as metaprotein) or groups within the 
samples of the experiment. The abundance corresponds to the sum of SC of the 
specific peptides present in a given subgroup or group. See 
\href{http://pappso.inrae.fr/bioinfo/xtandempipeline/}{X!TandemPipeline} 
for more details concerning the grouping algorithm.
}
\examples{
\dontrun{

# From a given "metaproteome_object" add the taxonomic classification

metaproteome <- load_protspeps(proteins_file, peptides_file, metadata_file)
metaproteome_taxo <- add_taxonomy(metaproteome, meta99_full_taxo) 

# Organize proteomics data by peptides OR subgroups OR groups

SC_specific_peptides <- getsc_specific(metaproteome_taxo, 'sc_specific_peptides') 
SC_specific_groups <- getsc_specific(metaproteome_taxo, 'sc_groups') 
SC_specific_subgroups <- getsc_specific(metaproteome_taxo, 'sc_subgroups') 

}
}
