% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_add_taxonomy.R
\name{add_taxonomy}
\alias{add_taxonomy}
\title{add_taxonomy}
\usage{
add_taxonomy(metaproteome_object, taxonomic_database)
}
\arguments{
\item{metaproteome_object}{List defined as "metaproteome_object" 
containing proteins and peptides abundances. The format of this 
object is similar to that generated from the function "load_protspeps".}

\item{taxonomic_database}{Dataframe containing the taxonomic information 
for each protein. The first column must contain the same identifiers 
of those present in the column "Accession" from the dataframe 
"peptides_proteins" of the "metaproteome_object". Two additional columns 
have to be present: i) one named "organism" containing the name of the strain
assigned to a given protein; and ii) the other named 
"species.genus.family.order.class.phylum.superkingdom". 
The taxonomic classification can be obtained from a tool of 
sequences aligment and must be ordered as follows: species, genus, 
family, order, class, phylum and superkingdom. The characters inside must 
be concatenated by a comma 
(ex."Streptococcus anginosus,Streptococcus,Streptococcaceae,Lactobacillales,Bacilli,Firmicutes,Bacteria").
An example can be found in this \href{https://zenodo.org/record/3997093}{repository}.}
}
\value{
A "metaproteome_object", which is a list of six elements with format
   similar to that generated from the function "load_protspeps". An additional 
   column containing the taxonomic annotation is added to the dataframe 
   named "peptides_proteins".
}
\description{
Integrates the database containing the taxonomic classification 
of the identified proteins in a "metaproteome_object". 
The taxonomic classification is previously obtained by aligment 
algorithms and must include seven taxonomic levels assigned 
to a given protein: species, genus, family, order, class, phylum 
and superkingdom
}
\examples{
\dontrun{

# Download taxonmical annotation db: https://zenodo.org/record/3997093#.X0UYI6Zb_mE 
meta99_full_taxo <- read.csv2("MetaHIT99_best_hit_taxo_complete.tsv", header = TRUE, sep="\t") 

# Files with spectral abundance and proteins list from X!Tandempipeline
protein_file <- "your/specific/location/protein_list.txt"
peptide_file <- "your/specific/location/peptide_counting.txt"
metadata_file <- "your/location/metadata.csv"

metaproteome <- load_protspeps(proteins_file, peptides_file, metadata_file)

metaproteome_taxo <- add_taxonomy(metaproteome, meta99_full_taxo) 

}
}
