% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homogen_power.R
\name{homogen_power}
\alias{homogen_power}
\title{Compute Power for Test of Homogeneity in Meta-analysis}
\usage{
homogen_power(
  effect_size,
  study_size,
  k,
  i2,
  es_type,
  p = 0.05,
  con_table = NULL
)
}
\arguments{
\item{effect_size}{Numerical value of effect size.}

\item{study_size}{Numerical value for number number of participants (per study).}

\item{k}{Numerical value for total number of studies.}

\item{i2}{Numerical value for Heterogeneity estimate (i^2).}

\item{es_type}{'Character reflecting effect size metric: 'r', 'd', or 'or'.}

\item{p}{Numerical value for significance level (Type I error probability).}

\item{con_table}{(Optional) Numerical values for 2x2 contingency table as a vector in the following format: c(a,b,c,d).

\tabular{lcc}{
 2x2 Table   \tab Group 1 \tab Group 2 \cr
 Present     \tab a       \tab b       \cr
 Not Present \tab c       \tab d       \cr
}}
}
\value{
Estimated Power to detect differences in homogeneity of effect sizes for fixed- and random-effects models
}
\description{
Compute statistical power for the Test of Homogeneity for meta-analysis under both fixed- and random-effects models.
}
\examples{
homogen_power(effect_size = .5, study_size = 10, k = 10, i2 = .50, es_type = "d")

}
\references{
Borenstein, M., Hedges, L. V., Higgins, J. P. T. and Rothstein, H. R.(2009). Introduction to meta-analysis, Chichester, UK: Wiley.

Hedges, L., Pigott, T. (2004). The Power of Statistical Tests for Moderators in Meta-Analysis, Psychological Methods, 9(4), 426-445.
doi: https://dx.doi.org/10.1037/1082-989x.9.4.426

Pigott, T. (2012). Advances in Meta-Analysis.
doi: https://dx.doi.org/10.1007/978-1-4614-2278-5
}
\seealso{
\url{https://jason-griffin.shinyapps.io/shiny_metapower/}
}
