% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_data_org.R
\name{utils_data_org}
\alias{utils_data_org}
\alias{add_seq_block}
\alias{recode_factor}
\alias{df_to_selegen_54}
\title{Utilities for data organization}
\usage{
add_seq_block(data, env, rep, new_factor = BLOCK, prefix = "", verbose = TRUE)

recode_factor(data, factor, new_factor = CODE, prefix = "", verbose = TRUE)

df_to_selegen_54(data, env, gen, rep, verbose = TRUE)
}
\arguments{
\item{data}{A data frame.}

\item{env}{The name of the column that contains the levels of the
environments.}

\item{rep}{The name of the column that contains the levels of the
replications/blocks.}

\item{new_factor}{The name of the new column created.}

\item{prefix}{An optional prefix to bind with the new factor.}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code will run
silently.}

\item{factor}{A column to recode.}

\item{gen}{The name of the column that contains the levels of the genotypes,
that will be treated as random effect.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Useful function for data organization before statistical analysis
\itemize{
\item \code{add_seq_block()}: Add a column with sequential block numeration in
multi-environment data sets.
\item \code{recode_factor()}: Recode a factor column. A sequential numbering (with
possible prefix) is used to identify each level.
\item \code{df_to_selegen_54()}: Given a multi-environment data with environment,
genotype, and replication, format the data to be used in the Selegen software
(model 54).
}
}
\examples{
\donttest{
library(metan)
df_ge <- ge_simula(ngen = 2,
                   nenv = 3,
                   nrep = 2) \%>\%
         add_cols(ENV = c(rep("CACIQUE", 4),
                          rep("FREDERICO", 4),
                          rep("SANTA_MARIA", 4)))
df_ge

# Add sequential block numbering over environments
add_seq_block(df_ge, ENV, REP, prefix = "B")

# Recode the 'ENV' column to "ENV1", "ENV2", and so on.
recode_factor(df_ge,
              factor = ENV,
              prefix = "ENV",
              new_factor = ENV_CODE)

# Format the data to be used in the Selegen software (model 54)
df <- df_to_selegen_54(df_ge, ENV, GEN, REP) \%>\%
recode_factor(ENV, prefix = "E", new_factor = ENV)
}

}
\references{
Resende, M.D. V. 2016. Software Selegen-REML/BLUP: a useful tool for plant
breeding. Crop Breed. Appl. Biotechnol. 16(4): 330–339.
\doi{10.1590/1984-70332016v16n4a49}.
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
