% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valmeta.r
\name{gelmanplot.valmeta}
\alias{gelmanplot.valmeta}
\title{Gelman-Rubin-Brooks plot}
\usage{
\method{gelmanplot}{valmeta}(x, confidence = 0.95, ...)
}
\arguments{
\item{x}{An mcmc object}

\item{confidence}{The coverage probability of the confidence interval for the potential scale reduction factor}

\item{\ldots}{Additional arguments which are currently not used}
}
\value{
A \code{ggplot} object.

An object of class \code{ggplot}
}
\description{
This plot shows the evolution of Gelman and Rubin's shrink factor as the number of iterations increases. The code is adapted from
the R package coda.
}
\examples{
\dontrun{
data(EuroSCORE)

# Meta-analysis of the concordance statistic
fit <- valmeta(cstat=c.index, cstat.se=se.c.index, cstat.cilb=c.index.95CIl,
               cstat.ciub=c.index.95CIu, N=n, O=n.events, 
               data=EuroSCORE, method="BAYES", slab=Study)
gelmanplot(fit)
} 

            
}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
