% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KH.Algorithm.R
\name{KH}
\alias{KH}
\title{Optimization using Krill-Herd Algorithm}
\usage{
KH(FUN, optimType = "MIN", numVar, numPopulation = 40, maxIter = 500,
  rangeVar, maxMotionInduced = 0.01,
  inertiaWeightOfMotionInduced = 0.01, epsilon = 1e-05,
  foragingSpeed = 0.02, inertiaWeightOfForagingSpeed = 0.01,
  maxDifussionSpeed = 0.01, constantSpace = 1, mu = 0.1)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization.
Otherwise, you can use \code{"MAX"} for maximization problem.
The default value is \code{"MIN"}.}

\item{numVar}{a positive integer to determine the number variables.}

\item{numPopulation}{a positive integer to determine the number populations. The default value is 40.}

\item{maxIter}{a positive integer to determine the maximum number of iterations. The default value is 500.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables,
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively.
If all variable have equal upper bound, you can define \code{rangeVar} as
matrix (\eqn{2 \times 1}).}

\item{maxMotionInduced}{a positive numeric between 0 and 1 to determine
maximum motion induced. The default value is 0.01.}

\item{inertiaWeightOfMotionInduced}{a positive numeric between 0 and 1 to determine
how much motion induced affect krill (candidate solution) movement. the
greater the value the greater the affect of motion induced on krill movement.
The default value is 0.01.}

\item{epsilon}{a positive numeric between 0 and 1 to determine epsilon constant. The default value is 1e-05.}

\item{foragingSpeed}{a positive numeric between 0 and 1 to determine foraging speed. The default value is 0.02}

\item{inertiaWeightOfForagingSpeed}{a positive numeric between 0 and 1 to determine
how much foraging speed affect krill (candidate solution) movement. the
greater the value the greater the affect of foraging speed on krill movement.
The default value is 0.01.}

\item{maxDifussionSpeed}{a positive numeric between 0 and 1 to determine maximum
difussion speed. The default value is 0.01.}

\item{constantSpace}{a numeric between 0 and 1 to determine how much range affect
krill movement. The default value is 1.}

\item{mu}{a numeric between 0 and 1 to determine constant number for mutation operator.
The default value is 0.1.}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Krill-Herd
Algorithm. It is used to solve continuous optimization tasks.
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
This algorithm was proposed by (Gandomi & Alavi, 2012).
It was inspired by behaviours of swarm of krill. Every
krill move based on motion induced (such as obstacle, predators),
foraging speed (food source) and physical difussion (swarm density).
In KH algorithm candidate solution represented by krill. KH algorithm
also use genetic operator mutation and crossover.

In order to find the optimal solution, the algorithm follow the following steps.
\itemize{
\item initialize population randomly.
\item calculate total motion based on motion induced, foraging speed and physical
      difussion for each candidate solutions and move it based on total motion.
\item perform genetic operator crossover and mutation
\item If a termination criterion (a maximum number of iterations or a sufficiently good fitness) is met,
      exit the loop, else back to calculate total motion.
}
}
\examples{
##################################
## Optimizing the sphere function

# define sphere function as objective function
sphere <- function(x){
    return(sum(x^2))
}

## Define parameter
numVar <- 5
rangeVar <- matrix(c(-10,10), nrow=2)

## calculate the optimum solution
resultKH <- KH(sphere, optimType="MIN", numVar, numPopulation=20,
                 maxIter=100, rangeVar)

## calculate the optimum value using sphere function
optimum.value <- sphere(resultKH)

}
\references{
Gandomi, A. H., & Alavi, A. H. (2012). Krill herd: a new bio-inspired optimization algorithm.
Communications in nonlinear science and numerical simulation, 17(12), 4831-4845.
}
\seealso{
\code{\link{metaOpt}}
}
