% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgbin.R
\name{mgbin}
\alias{mgbin}
\title{Group Studies with Binary Outcome Data by Homogeneity}
\usage{
mgbin(data, event.e, n.e, event.c, n.c, studlab, ...)
}
\arguments{
\item{data}{A data frame containing the meta-analysis data.}

\item{event.e}{A vector of event counts in the experimental group.}

\item{n.e}{A vector of sample sizes in the experimental group.}

\item{event.c}{A vector of event counts in the control group.}

\item{n.c}{A vector of sample sizes in the control group.}

\item{studlab}{A vector of study labels.}

\item{...}{Additional arguments passed on to `meta::metabin`.}
}
\value{
A list containing the final data with subgroup assignments (`data`),
the final `metabin` model (`model`), and the number of attempts (`attempts`).
}
\description{
This function iteratively assigns studies to subgroups based on a homogeneity
test. The goal is to create statistically homogeneous groups of studies
before performing a final meta-analysis with binary outcome data.
}
\details{
The algorithm starts with a single study in "group 1". It then processes
each subsequent study, attempting to place it in an existing group. A study
is added to a group only if its inclusion does not result in significant
within-group heterogeneity. If no suitable group is found, a new one is created.
}
\seealso{
\code{\link{meaning}}
}
\author{
Ahmed Abdelmageed \email{ahmedelsaeedmassad@gmail.com}
}
