% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meaning.R
\name{meaning}
\alias{meaning}
\title{Explore Composition of Homogeneous Study Subgroups}
\usage{
meaning(data, subgroup = "subgroup", variables, min = 3)
}
\arguments{
\item{data}{A data frame or the list object returned by a meta-grouping function.
If a list, the function will automatically use the `data` element.}

\item{subgroup}{A string specifying the name of the subgroup column. Defaults to `"subgroup"`.}

\item{variables}{A character vector of column names (categorical variables) to analyze.}

\item{min}{An integer specifying the minimum number of studies a group must have
to be included in the final summarized output. Defaults to 3.}
}
\value{
An S3 object of class `grouped`, which is a list containing three data frames:
\itemize{
  \item `detailed`: Contains the percentage distribution for all categories of all variables within every group.
  \item `up.hand`: A subset of `detailed`, showing only the dominant category for each variable in each group.
  \item `final`: A summarized version of `up.hand`, showing the single most dominant characteristic for each group that meets the `min` size threshold. This is the default print output.
}
}
\description{
After grouping studies using a meta-grouping function (e.g., `mgbin`), this
function analyzes the composition of each subgroup based on specified
categorical variables. It helps to give "meaning" to the statistically derived groups.
}
\details{
For each subgroup and each specified variable, the function calculates the
percentage distribution of its categories. It identifies the most frequent
(dominant) category and performs a chi-squared test to assess if the
distribution of categories within that group is significantly different from random.
}
\examples{
# Create a sample dataset of studies
study_data <- data.frame(
  author = letters[1:10],
  country = sample(c("USA", "China", "Egypt"), 10, replace = TRUE),
  setting = sample(c("Hospital", "Community"), 10, replace = TRUE),
  subgroup = c("group 1", "group 2", "group 1", "group 1", "group 2",
               "group 2", "group 1", "group 3", "group 2", "group 2")
)

# Analyze the composition of the subgroups
meaning_result <- meaning(study_data, variables = c("country", "setting"))

# The default print shows the 'final' summary table
print(meaning_result)

# Access detailed results
# meaning_result$detailed

}
\seealso{
\code{\link{mgbin}}, \code{\link{mgcont}}, \code{\link{mgcor}}
}
\author{
Ahmed Abdelmageed \email{ahmedelsaeedmassad@gmail.com}
}
