% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nebs.R
\name{linesonfes}
\alias{linesonfes}
\title{Plot lines for Nudged Elastic Band projected onto free energy surface}
\usage{
linesonfes(x, col = "red", lwd = 1)
}
\arguments{
\item{x}{nebpath object.}

\item{col}{color code or name, see 'par'.}

\item{lwd}{line width for drawing symbols see 'par'.}
}
\description{
`linesonfes` plots lines for free energy profile calculated by Nudged Elastic Band
projected onto free energy surface.
}
\examples{
tfes<-fes(acealanme, imax=5000)
minima<-fesminima(tfes)
nebAD<-neb(minima, min1="A", min2="D", nsteps=20)
plot(minima)
linesonfes(nebAD)
}
