% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nebs.R
\name{lines.nebpath}
\alias{lines.nebpath}
\title{Plot lines for Nudged Elastic Band}
\usage{
\method{lines}{nebpath}(x, col = "red", lwd = 1, ...)
}
\arguments{
\item{x}{nebpath object.}

\item{col}{color code or name, see 'par'.}

\item{lwd}{line width for drawing symbols see 'par'.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
`lines.nebpath` plots lines for free energy profile calculated by Nudged Elastic Band.
}
\examples{
tfes<-fes(acealanme, imax=5000)
minima<-fesminima(tfes)
nebAD<-neb(minima, min1="A", min2="D", nsteps=20)
plot(nebAD)
lines(nebAD, lwd=4)
}
