% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportLongPrior.R
\name{ImportLongPrior}
\alias{ImportLongPrior}
\title{ImportLongPrior}
\usage{
ImportLongPrior(longPrior, featureMat, metaMat)
}
\arguments{
\item{longPrior}{long-format dataframe as generated by
Metadeconfound(returnLong = TRUE). Must contain at least one column
containing feature names and one column containing associated metadata names,
called "feature" and "metaVariable", respectively. Only associations between
features and metadata present in featureMat and metaMat will be returned.
Additionally, "Qs" and "status" (as produced by
\link[metadeconfoundR]{MetaDeconfound})columns can be supplied and will
be parsed as well.
If only "feature" and "metaVariable" columns are supplied, all listed
associations are assumed to be significant.
If "status" is supplied, only non-"NS" labeled associations will be kept.}

\item{featureMat}{omics features to be analyzed by \link[metadeconfoundR]{MetaDeconfound}}

\item{metaMat}{metadata to be analyzed by \link[metadeconfoundR]{MetaDeconfound}}
}
\value{
wide-format dataframe that can be used as minQValues parameter in
\link[metadeconfoundR]{MetaDeconfound}
}
\description{
ImportLongPrior imports prior knowledge of associations between individual
features and metadata in form of a long-format dataframe.
}
\details{
This function is meant to facilitate incorporation of prior
knowledge about associations between measured omics features and available
metadata both from earlier metadeconfoundR runs by supplying the long-format
Metadeconfound(returnLong = TRUE) output directly or by supplying a simple
list of known associations from other studies.
}
\examples{
data(reduced_feature)
data(metaMatMetformin)
\donttest{

# note that this example is only to demonstrate the process of integrating
 # prior knowledge into a MetaDeconfound() analysis. Using the output of a
 # MetaDeconfound() run as minQValues input for a second run with the exact
 # same features and metadata will not lead to any new insights since the set
 # of QValues calculated by MetaDeconfound() and the set supplied using the
 # minQValues parameter are identical in this case.

example_output <- MetaDeconfound(featureMat = reduced_feature,
                                  metaMat = metaMatMetformin,
                                  returnLong = TRUE,
                                  logLevel = "ERROR")

minQValues <- ImportLongPrior(longPrior = example_output,
                                featureMat = reduced_feature,
                                metaMat = metaMatMetformin)

example_output2 <- MetaDeconfound(featureMat = reduced_feature,
                                  metaMat = metaMatMetformin,
                                  minQValues = minQValues,
                                  logLevel = "ERROR")
}
}
