% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params}
\alias{params}
\title{Documentation for params common across metabias packages.}
\arguments{
\item{yi}{A vector of point estimates to be meta-analyzed.}

\item{vi}{A vector of estimated variances (i.e., squared standard errors) for
the point estimates.}

\item{sei}{A vector of estimated standard errors for the point estimates.
(Only one of \code{vi} or \code{sei} needs to be specified).}

\item{cluster}{Vector of the same length as the number of rows in the data,
indicating which cluster each study should be considered part of (defaults
to treating studies as independent; i.e., each study is in its own cluster).}

\item{favor_positive}{\code{TRUE} if publication bias are
assumed to favor significant positive estimates; \code{FALSE} if assumed to
favor significant negative estimates.}

\item{alpha_select}{Alpha level at which an estimate's probability of being
favored by publication bias is assumed to change (i.e.,
the threshold at which study investigators, journal editors, etc., consider
an estimate to be significant).}

\item{ci_level}{Confidence interval level (as proportion) for the corrected
point estimate. (The alpha level for inference on the corrected point
estimate will be calculated from \code{ci_level}.)}

\item{small}{Should inference allow for a small meta-analysis? We recommend
always using \code{TRUE}.}

\item{selection_ratio}{Ratio by which publication bias favors affirmative
studies (i.e., studies with p-values less than \code{alpha_select} and
estimates in the direction indicated by \code{favor_positive}).}

\item{q}{The attenuated value to which to shift the point estimate or CI.
Should be specified on the same scale as \code{yi} (e.g., if
\code{yi} is on the log-RR scale, then \code{q} should be as well).}
}
\description{
Documentation for params common across metabias packages.
}
