% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SE.R
\name{SEp_from_CIp}
\alias{SEp_from_CIp}
\title{Standard Error from Confidence Interval for Differences of Means}
\usage{
SEp_from_CIp(
  CI_low,
  CI_up,
  n1 = NA,
  n2 = NA,
  sig_level = 0.05,
  two_tailed = TRUE,
  t_dist = TRUE
)
}
\arguments{
\item{CI_low}{lover OR confidence interval limit}

\item{CI_up}{upper OR confidence interval limit}

\item{n1}{sample size group 1 (not required if t_dist = FALSE)}

\item{n2}{sample size group 2 (not required if t_dist = FALSE)}

\item{sig_level}{the significance level}

\item{two_tailed}{whether the two-tailed or one-tailed statistics should be calculated}

\item{t_dist}{whether the t-distribution should be calculated - requires samples sizes}
}
\value{
Pooled standard error (e.g. intervention effect)
}
\description{
Calculates the standard error from the confidence interval limits for differences of means (and can also be used for the confidence intervals of standardized mean differences, SMD).
This method is valid only when the confidence interval is symmetrical around the mean and is applicable for t-distributions or normal distributions (as specified by the \code{t_dist} argument).
For sample sizes less than 60, it is generally recommended to use the t-distribution.
}
\examples{
# lower CI = -1.5, upper CI = 0.5
SEp_from_CIp(-1.5, 0.5)
}
\references{
\href{https://handbook-5-1.cochrane.org/chapter_7/7_7_3_2_obtaining_standard_deviations_from_standard_errors_and.htm}{Cochrane Handbook}
}
