% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SD.R
\name{SD_from_CI}
\alias{SD_from_CI}
\title{Standard Deviation from Confidence Interval}
\usage{
SD_from_CI(CI_low, CI_up, n, sig_level = 0.05, two_sided = TRUE, t_dist = TRUE)
}
\arguments{
\item{CI_low}{lower limit confidence interval}

\item{CI_up}{upper limit confidence interval}

\item{n}{sample size}

\item{sig_level}{significance level}

\item{two_sided}{whether a two sided test for significance was used}

\item{t_dist}{whether a t-distribution has been used to calculate the CI. See description.}
}
\value{
Standard deviation single group
}
\description{
Computes the standard deviation from the confidence interval and sample size. This method is valid only for single groups and assumes the confidence interval is symmetrical around the mean. For two groups (e.g., intervention effects), use \code{\link[=SDp_from_CIp]{SDp_from_CIp()}}. For sample sizes smaller than 60, the t-distribution (parameter "t-dist") is typically used to calculate the confidence interval.
}
\examples{
# lower CI = -0.5, upper CI = 2, sample size = 100
SD_from_CI(-05, 2, 100)
}
\references{
\href{https://handbook-5-1.cochrane.org/chapter_7/7_7_3_2_obtaining_standard_deviations_from_standard_errors_and.htm}{Cochrane Handbook}
}
\seealso{
\code{\link[=SDp_from_CIp]{SDp_from_CIp()}} for two groups (e.g. intervention effects).
}
