% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage.R
\name{storage.unset}
\alias{storage.unset}
\title{Unset a value that corresponds to a key within a store.}
\usage{
storage.unset(storage, key)
}
\arguments{
\item{storage}{initialized storage}

\item{key}{key whose value is to be unset}
}
\value{
Invisibily returns storage
}
\description{
Unsets the value stored for a given key.

If there is no value for the key provided no action is taken.
}
\examples{
library(magrittr)

# initialize default memory storage
my.storage <- storage.init()

# set a value into storage
storage.set(my.storage, "name", "Roy Wetherall")

# .. and some more
my.storage \%>\% 
  storage.set("age", 45) \%>\% 
  storage.set("alive", TRUE) \%>\%
  storage.set("children", c("Peter", "Grace", "Lucy"))

# check a key has been set
if (storage.has(my.storage, "name")) print("I know your name!")

# .. and that a key hasn't been set
if (!storage.has(my.storage, "address")) print("I don't know where you live!")

# get some values from storage
sprintf(
  "\%s is \%i years old.", 
  storage.get(my.storage, "name"),
  storage.get(my.storage, "age"))

# remove a value from storage
storage.unset(my.storage, "children")

# .. and show it's not there anymore
if (!storage.has(my.storage, "address")) print("I don't know who your children are!")

# clear all values from storage
storage.clear(my.storage)

# .. and everything is gone
if (!storage.has(my.storage, "name") && !storage.has(my.storage, "age")) print("I know nothing!")
}
