% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/logLR-methods.R
\name{logLR}
\alias{logLR}
\alias{logLR,EL-method}
\alias{logLR,ELT-method}
\alias{logLR,SummaryEL-method}
\alias{logLR,SummaryELT-method}
\alias{logLR,SummaryLM-method}
\title{Empirical log-likelihood ratio}
\usage{
\S4method{logLR}{EL}(object, ...)

\S4method{logLR}{ELT}(object, ...)

\S4method{logLR}{SummaryEL}(object, ...)

\S4method{logLR}{SummaryELT}(object, ...)

\S4method{logLR}{SummaryLM}(object, ...)
}
\arguments{
\item{object}{An object that contains the empirical log-likelihood ratio.}

\item{...}{Further arguments passed to methods.}
}
\value{
A single numeric.
}
\description{
Extracts the empirical log-likelihood ratio from a model.
}
\examples{
data("precip")
fit <- el_mean(precip, par = 40)
logLR(fit)
}
\references{
Baggerly KA (1998).
``Empirical Likelihood as a Goodness-of-Fit Measure.''
\emph{Biometrika}, \strong{85}(3), 535--547.
\doi{10.1093/biomet/85.3.535}.
}
\seealso{
\linkS4class{EL}, \linkS4class{ELT}
}
