% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barmekko.R
\name{barmekko}
\alias{barmekko}
\title{Create a bar mekko plot.}
\usage{
barmekko(data, x, y, width, values = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{x}{A categorical variable defining the width categories.}

\item{y}{A numeric variable defining the bar height.}

\item{width}{A numeric variable defining the bar widths}

\item{values}{A boolean indicating whether to show value labels in bars}
}
\value{
A bar mekko constructed with ggplot2.
}
\description{
A smarter bar chart.
}
\examples{
library(ggplot2)
df <- data.frame(
  region = c('Northeast', 'Southeast', 'Central', 'West'),
  sales = c(1200, 800, 450, 900),
  avg_margin = c(3.2, -1.4, 0.1, 2.1)
  )
barmekko(df, region, avg_margin, sales)
barmekko(df, region, avg_margin, sales) + labs(title = 'Margins by Region')
barmekko(df[order(-df$sales),], region, avg_margin, sales)
barmekko(df[order(-df$avg_margin),], region, avg_margin, sales)
}

