% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_md.R
\name{parse_md}
\alias{parse_md}
\alias{parse_gfm}
\title{Parse markdown}
\usage{
parse_md(md, flags = "MD_DIALECT_COMMONMARK")

parse_gfm(md, flags = "MD_DIALECT_GITHUB")
}
\arguments{
\item{md}{Character. Either literal string of markdown or a path to a markdown file.}

\item{flags}{Character vector. Dialect flags used by the parser.}
}
\value{
Both functions return a markdown ast, a list with the \code{md_block_doc} class.
}
\description{
Parse either a literal markdown string or a markdown file
given a path. Different dialects and features are supported via the \code{flags}
argument. See \code{\link[=flags_describe]{flags_describe()}} for possible flags and their usage. \code{parse_md()}
defaults parsing using the commonmark spec while \code{parse_gfm()} uses the GitHub
flavored markdown spec.
}
\examples{
parse_md(system.file("examples/commonmark.md", package = "md4r"))

parse_gfm(system.file("examples/github.md", package = "md4r"))

}
