% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md.log.R
\name{md.log}
\alias{md.log}
\title{md.log}
\usage{
md.log(msg, file = "", append = FALSE, sys.info = TRUE,
section="monospace", level="", trace=TRUE, date=FALSE,
time=FALSE, print=FALSE, datetime.fmt="\%Y-\%m-\%d \%H:\%M:\%S")
}
\arguments{
\item{msg}{the text that is to be printed in the log file. By default
\code{msg} is printed as monospace code inside the Markdown log,
unless the \code{section} argument is used to change this behavior.}

\item{file}{A connection, or a character string naming the file to
print to. If \code{""} (the default), the \code{msg} is printed to the
standard output connection or the previously defined log file}

\item{append}{logical. Only used if the argument file is the name
of file (and not a connection). If \code{TRUE}, output will be
appended to file; otherwise, it will overwrite the contents of file.}

\item{sys.info}{logical. Only used Only used if the argument file is the name
of file (and not a connection). If \code{TRUE}, the system information,
R version, and date and time will be printed at the outset of the
log file.}

\item{section}{styles the \code{msg} argument with Markdown syntax
and it can be \code{monospace}, \code{section}, \code{subsection},
or \code{paragraph}. the default value is \code{monospace}.}

\item{level}{is a marker that is printed at the beginning of each
\code{monospace} massage and cannot be more than seven characters
long. this argument can be used to distinct massages with warnings
or errors}

\item{trace}{logical. If \code{TRUE}, the function call is included
before each \code{msg}}

\item{date}{logical. if \code{TRUE}, the current date is included
before each \code{msg}}

\item{time}{logical. if \code{TRUE}, the current time is included
before each \code{msg}}

\item{print}{logical. if \code{TRUE}, the massage is
printed in R console as well.}

\item{datetime.fmt}{specifies the format of date and time arguments
and by default is \code{"\%Y-\%m-\%d \%H:\%M:\%S"}. whitespace should
only be used to separate the date and time formats}
}
\description{
produces Markdown log files with an optional argument
to include the function call inside the Markdown log file.
}
\examples{
# --------------------------------------------------------------------
# Testing the md.log package
# ====================================================================

child = function() {
  md.log("current function", level="dope!")
}

parent = function(){
 md.log("step 2")
 child()
}

grandparent = function() {
 md.log("step 3")
 parent()
}

# The main test function that produces the log and calls the other functions
md.log.test = function() {
 require(md.log)
 md.log("Initiating a new Markdown log", file="markdown.log")

 # starting the logs
 md.log("a simple MONOSPACE log")
 md.log("Adding a level", level="notice")
 md.log("level makes you pay attention to a particular line")

 # add a subsection and a paragraph in the log
 md.log("This is a subsection", section="subsection")
 md.log("This is a text paragraph for detailed explanation...", section="paragraph")

 # testing the function call
 child()
 md.log("so far so good! now let's test a more complex nest")
 grandparent()
}

md.log.test()
}
\author{
E. F. Haghish \cr
Institute for Community Medicine \cr
University of Greifswald, Germany \cr
\email{haghish@uni-greifswald.de} \cr
and \cr
Institute for Medical Informatics (IMBI) \cr
University of Freiburg, Germany \cr
\email{haghish@imbi.uni-freiburg.de} \cr
}
