% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcNgMMDeming.r
\name{mc.mmNgdemingConstCV}
\alias{mc.mmNgdemingConstCV}
\title{Calculate MM Deming Regression}
\usage{
mc.mmNgdemingConstCV(
  X,
  Y,
  error.ratio,
  iter.max = 30,
  threshold = 1e-06,
  kM = 1.345,
  tauMM = 4.685,
  bdPoint = 0.5,
  priorSlope = 1,
  priorIntercept = 0
)
}
\arguments{
\item{X}{measurement values of reference method.}

\item{Y}{measurement values of test method.}

\item{error.ratio}{ratio between squared measurement errors of reference- and test method, necessary for Deming regression (Default is 1).}

\item{iter.max}{maximal number of iterations.}

\item{threshold}{threshold value.}

\item{kM}{Huber's k for the M weighting, default kM = 1.345}

\item{tauMM}{Tukey's tau for bisquare redescending weighting function, default tauMM = 4,685}

\item{bdPoint}{Proportion of data points selected for the highly robust M regression used for the determination of the starting parameters. Default 0.5}

\item{priorSlope}{starting slope value for PiMMDeming, default priorSlope = 1}

\item{priorIntercept}{starting intercept value for PiMMDeming, default priorIntercept = 0}
}
\value{
a list with elements
 \item{b0}{intercept.}
 \item{b1}{slope.}
 \item{xw}{average of reference method values.}
 \item{iter}{number of iterations.}
}
\description{
Calculate MM Deming regression with iterative algorithm inspired on the work of Linnet.
The algorithm uses bisquare redescending weights. For maximal stability and convergence
the euclidean residuals are scaled in each iteration with a fresh calculated MAD instead of
keeping the same MAD (assessed at the starting step) for the whole iteration.
This algorithm is available only for positive values. But even in this case there is no guarantee that
the algorithm always converges.
}
\references{
Linnet K.
             Evaluation of Regression Procedures for Methods Comparison Studies.
             CLIN. CHEM. 39/3, 424-432 (1993).

             Linnet K.
             Estimation of the Linear Relationship between the Measurements of two Methods with Proportional Errors.
             STATISTICS IN MEDICINE, Vol. 9, 1463-1473 (1990).
}
