% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mclustAddons-package.R
\docType{data}
\name{gold}
\alias{gold}
\title{Gold price log-returns}
\format{
A data frame with the following variables:
\describe{
\item{date}{Date (format: yyyy-mmm-dd).}
\item{log.returns}{Daily log-return.}
}
}
\description{
Gold price log-returns for the year 2023 obtained from Yahoo Finance using
the \code{quantmod} R package.
Code used to download, format, and save the data:
\preformatted{
gold = quantmod::getSymbols("GC=F", src = "yahoo", auto.assign = FALSE)
gold = quantmod::dailyReturn(gold, type = "log")
gold = data.frame("date" = as.Date(zoo::index(gold)),
                  "log.returns" = as.vector(gold$daily.returns), 
                  row.names = NULL)
}
}
\keyword{datasets}
