% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/tokenize.R
\name{trunc_at}
\alias{trunc_at}
\alias{trunc_at.tokens}
\title{Truncate a sequence of character data}
\usage{
trunc_at(x, pattern, ...)

\method{trunc_at}{tokens}(
  x,
  pattern,
  keep_this = FALSE,
  last_match = FALSE,
  from_end = FALSE,
  ...
)
}
\arguments{
\item{x}{An object that represents a sequence of character data.}

\item{pattern}{A regular expression.}

\item{...}{Additional arguments.}

\item{keep_this}{Logical. Whether the matching token itself should be kept.
If \code{TRUE}, the truncating happens right after the matching token; if \code{FALSE},
right before.}

\item{last_match}{Logical. In case there are several matching tokens, if
\code{last_match} is \code{TRUE}, the last match will be used as truncating point;
otherwise, the first match will.}

\item{from_end}{Logical. If \code{FALSE}, the match starts from the first token progressing
forward; if \code{TRUE}, it starts from the last token progressing backward.

If \code{from_end} is \code{FALSE}, the part of \code{x} that is kept after truncation is
the head of \code{x}. If it is \code{TRUE} instead, the part that is kept after truncation
is the tail of \code{x}.}
}
\value{
A truncated version of \code{x}.
}
\description{
This method takes as its argument \code{x} an object that represents a sequence of
character data, such as an object of class \code{\link{tokens}}, and truncates it at the
position where a match for the argument \code{pattern} is found. Currently it is
only implemented for \code{\link{tokens}} objects.
}
\examples{
(toks <- tokenize('This is a first sentence . This is a second sentence .',
re_token_splitter = '\\\\s+'))

trunc_at(toks, re("[.]"))

trunc_at(toks, re("[.]"), last_match = TRUE)

trunc_at(toks, re("[.]"), last_match = TRUE, from_end = TRUE)
}
