% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnames.R
\name{merge_fnames}
\alias{merge_fnames}
\alias{fnames_merge}
\alias{fnames_merge_all}
\title{Merge filenames collections}
\usage{
fnames_merge(x, y, sort = FALSE)

fnames_merge_all(..., sort = FALSE)
}
\arguments{
\item{x, y}{An object of class \code{\link{fnames}}.}

\item{sort}{Boolean value. Should the items in the output be sorted?}

\item{...}{Various objects of class \code{\link{fnames}} or a list of
objects of class \code{\link{fnames}}.}
}
\value{
An object of class \code{\link{fnames}}.
}
\description{
These functions merge two or more \code{\link{fnames}} objects into one larger \code{\link{fnames}}
object, removing duplicates (keeping only the first appearance) and only
resorting the items if \code{sort = TRUE}.
}
\examples{
cwd_fnames <- as_fnames(c("file1.txt", "file2.txt"))
cwd_fnames2 <- as_fnames(c("dir1/file3.txt", "dir1/file4.txt"))
cwd_fnames3 <- as_fnames(c("dir2/file5.txt", "dir2/file6.txt"))
fnames_merge(cwd_fnames, cwd_fnames2)
fnames_merge_all(cwd_fnames, cwd_fnames2, cwd_fnames3)
}
