% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/re.R
\name{cat_re}
\alias{cat_re}
\title{Print a regular expression to the console}
\usage{
cat_re(x, format = c("plain", "R"), as_single_line = TRUE)
}
\arguments{
\item{x}{An object of class \code{\link{re}} or a character vector containing a regular
expression. If \code{x} is a character vector of length higher than 1, only its
first element will be used.}

\item{format}{Character vector describing the requested format (as a \code{"plain"}
regular expression or as an \code{"R"} string). If its length is higher than 1,
only its first element will be used.}

\item{as_single_line}{Logical. Whether \code{x} should be converted to a single line
regular expression, therefore also removing all comments, prior to printing.
If the length of this vector is larger than 1, only its first item will be used.}
}
\value{
Invisibly, \code{x}.
}
\description{
The function \code{\link[=cat_re]{cat_re()}} prints a regular expression to the console.
By default, the regular expression is not printed as an R string,
but as a `plain regular expression'. More specifically, the regular expression
is printed without surrounding quotation marks, and characters that are
special characters in R strings (such as quotation marks and backslashes)
are not escaped with a backslash. Also, by default, multi-line regular expressions are
printed as single-line regular expressions with all regular expression comments removed.
}
\details{
WARNING: In the current implementation, the way the character \verb{#} is handled is
not guaranteed to be correct. More specifically, the code is not guaranteed
to correctly distinguish between a \verb{#} symbol that introduces a regular
expression comment and a \verb{#} symbol that doesn't do so. Firstly,
there is no testing whether at the point of encountering \verb{#} we're in
free-spacing mode. Second, there is no thorough testing whether or not
the \verb{#} symbol is part of a character class.
However, \verb{#} is processed correctly as long as any 'literal #' is
immediately preceded by either a backslash or an opening square bracket,
and any `comment-introducing #' is not immediately preceded by
a backslash or an opening square bracket.
}
\examples{
# single-line regular expression
x <- "(?xi)  \\\\b \\\\w* willing \\\\w* \\\\b"
cat_re(x)
y <- "(?xi)  
       \\\\b        # word boundary 
       \\\\w*       # optional prefix
       willing   # stem
       \\\\w*       # optional suffix
       \\\\b        # word boundary"
cat_re(y)
cat_re(y, as_single_line = FALSE)
cat_re(y, format = "R")
cat_re(y, format = "R", as_single_line = FALSE)

regex <- re("(?xi)  
                \\\\b        # word boundary 
                \\\\w*       # optional prefix
                willing   # stem
                \\\\w*       # optional suffix
                \\\\b        # word boundary")
cat_re(regex)
cat_re(regex, as_single_line = FALSE)
}
\seealso{
\code{\link[=scan_re]{scan_re()}}
}
