% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{similarity_metrics}
\alias{similarity_metrics}
\alias{getNumberOfCommonEdges}
\alias{getSizeOfLargestCommonSubtree}
\title{Metrics for spanning tree comparisson.}
\usage{
getNumberOfCommonEdges(x, y, n = NULL, normalize = TRUE)

getSizeOfLargestCommonSubtree(x, y, n = NULL, normalize = TRUE)
}
\arguments{
\item{x}{[\code{matrix(2, n)}]\cr
First spanning tree represented as a list of edges.}

\item{y}{[\code{matrix(2, n)}]\cr
Second spanning tree represented as a list of edges.}

\item{n}{[\code{integer(1)} | \code{NULL}]\cr
Number of nodes of the graph.
Defaults to \code{length(x)}.}

\item{normalize}{[\code{logical(1)}]\cr
Should measure be normalized to \eqn{[0, 1]} by devision
through the number of edges?
Default is \code{TRUE}.}
}
\value{
[\code{numeric(1)}] Measure
}
\description{
Functions which expect two (spanning) trees and return a measure
of similiarity between those. Function \code{getNumberOfCommonEdges} returns
the (normalized) number of shared edges and function \code{getSizeOfLargestCommonSubtree}
returns the (normalized) size of the largest connected subtree which is located in
both trees.
}
\examples{
# Here we generate two random spanning trees of a complete
# graph with 10 nodes
set.seed(1)
st1 = prueferToEdgeList(sample(1:10, size = 8, replace = TRUE))
st2 = prueferToEdgeList(sample(1:10, size = 8, replace = TRUE))
# Now check the number of common edges
NCE = getNumberOfCommonEdges(st1, st2)
# And the size of the largest common subtree
SLS = getSizeOfLargestCommonSubtree(st1, st2)
}
