% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{edgeListToCharVec}
\alias{edgeListToCharVec}
\title{Convert edge list to characteristic vector.}
\usage{
edgeListToCharVec(edgelist, n = NULL)
}
\arguments{
\item{edgelist}{[\code{matrix(2, k)}]
Matrix of edges (each column is one edge).}

\item{n}{[\code{integer}]\cr
Number of nodes of the problem.}
}
\value{
[\code{integer}] Characteristic vector cv with cv[i] = 1 if the i-th edge is in the tree.
}
\description{
Convert edge list to characteristic vector.
}
\examples{
# first we generate a small edge list by hand
# (assume the given graph has n = 4 nodes)
edgelist = matrix(c(1, 2, 2, 4, 3, 4), ncol = 3)
print(edgelist)
# next we transform the edge into
# a characteristic vector
cvec = edgeListToCharVec(edgelist, n = 4)
print(cvec)
}
\seealso{
Other transformation functions: 
\code{\link{charVecToEdgelist}()},
\code{\link{nodelistToEdgelist}()},
\code{\link{permutationToCharVec}()},
\code{\link{permutationToEdgelist}()},
\code{\link{prueferToCharVec}()},
\code{\link{prueferToEdgeList}()}
}
\concept{transformation functions}
