% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSimilarityMatrix.R
\name{computeSimilarityMatrix}
\alias{computeSimilarityMatrix}
\title{Compute similarity matrix.}
\usage{
computeSimilarityMatrix(set, sim.fun, ...)
}
\arguments{
\item{set}{[\code{list}]\cr
List of objects.}

\item{sim.fun}{[\code{function(x, y, ...)}]\cr
Function which expects two objects \code{x} and \code{y} as first and second
arguments and returns a scalar value.}

\item{...}{[any]\cr
Passed down to \code{sim.fun}.}
}
\value{
[\code{matrix(n, n)}] \eqn{(n,n)} matrix with \eqn{n} being the length of \code{set}.
}
\description{
Given a list of objects and a function which computes a similarity
measure between two objects of the list, \code{computeSimilarity} returns a
similarity matrix.
}
