% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cvg.R
\docType{methods}
\name{plot_cvg}
\alias{plot_cvg}
\alias{plot_cvg,mbsts-method}
\title{Plot for Convergence Diagnosis}
\usage{
plot_cvg(
  object,
  index,
  type = "o",
  col = "blue",
  pch = 16,
  lty = 1,
  xlab = "Number of iterations",
  ylab = "Estimation",
  main = "Predictor",
  cex.axis = 1.15
)

\S4method{plot_cvg}{mbsts}(
  object,
  index,
  type = "o",
  col = "blue",
  pch = 16,
  lty = 1,
  xlab = "Number of iterations",
  ylab = "Estimation",
  main = "Predictor",
  cex.axis = 1.15
)
}
\arguments{
\item{object}{An object of the mbsts class created by a call to the mbsts_function function.}

\item{index}{A numerical value indicating which predictor to analyze. The index can be generated by a call to the para.est function}

\item{type}{NULL or a character vector whose entries are titles for the plots of target series' posterior state components, such as c("Posterior State Components of y1", "Posterior State Components of y2"). The default is c("y1","y2",...).}

\item{col}{The same setting as that of the plot function in the base package.}

\item{pch}{The same setting as that of the plot function in the base package.}

\item{lty}{The same setting as that of the plot function in the base package.}

\item{xlab}{The same setting as that of the plot function in the base package.}

\item{ylab}{The same setting as that of the plot function in the base package.}

\item{main}{The same setting as that of the plot function in the base package.}

\item{cex.axis}{The same setting as that of the plot function in the base package.}
}
\description{
Plot of the parameter draw for MCMC iterations after burn-in.
}
\references{
\Qiu2018

\Ning2021

\Jammalamadaka2019
}
\author{
Ning Ning \email{patricianing@gmail.com}
}
