% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass-balance-optim.R
\name{mb_fit}
\alias{mb_fit}
\title{Fit parameters with mass balance criterion}
\usage{
mb_fit(X, Y, lambda, mus, sigmas, log.seasons, log.ann, N, sInd)
}
\arguments{
\item{X}{Inputs, must have columns of 1 added}

\item{Y}{Observed Dry, Wet, and Annual log-transformed flows}

\item{lambda}{Penalty weight.}

\item{mus}{A vector of means, one for each target.}

\item{sigmas}{A vector of the standard deviations, one for each target.}

\item{log.seasons}{A vector containing the indices of the seasons that are log-transformed.}

\item{log.ann}{TRUE if the annual reconstruction is log-transformed.}

\item{N}{The number of targets (number of seasons plus one for the annual reconstruction).}

\item{sInd}{Indices of the seasons, i.e, 1...N-1}
}
\value{
A one-column matrix of beta value
}
\description{
Fit parameters with mass balance criterion
}
