% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_functions.R
\name{rmse_raster_to_point}
\alias{rmse_raster_to_point}
\title{Generate RMSE from an estimated raster surface and point data}
\usage{
rmse_raster_to_point(estimates, validation_data, outcome_field, na.rm = FALSE)
}
\arguments{
\item{estimates}{(\link[terra:SpatRaster-class]{terra::SpatRaster}) Raster surface containing point estimates. This
could also be the mean surface of a Bayesian geostatistical model}

\item{validation_data}{(\code{data.frame})\cr
Table containing at least the following fields:\cr
\itemize{
\item x (\code{numeric}) location x position, in the same projection as \code{estimates}\cr
\item y (\code{numeric}) location y position, in the same projection as \code{estimates}\cr
\item (Outcome field) See below
}}

\item{outcome_field}{(\code{character(1)}) Column in \code{validation_data} containing the values
that should be compared against the \code{estimates} raster surface.}

\item{na.rm}{(\code{logical(1)}, default FALSE) Should NA values be dropped from the RMSE
calculation?}
}
\value{
A single number giving RMSE between the point data and estimates raster.
}
\description{
Generate RMSE from an estimated raster surface and point data
}
\details{
For examples, see \code{vignette('model-comparison', package = 'mbg')}
}
\concept{validation}
