% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma.R
\name{rmatrixgamma}
\alias{rmatrixgamma}
\title{Matrix Gamma sampler}
\usage{
rmatrixgamma(n, nu, theta, Sigma = NULL, p, checkSymmetry = TRUE)
}
\arguments{
\item{n}{sample size, a positive integer}

\item{nu}{shape parameter, a positive number; if \code{nu < (p-1)/2},
where \code{p} is the dimension (the order of \code{Sigma}), then \code{nu}
must be a half integer}

\item{theta}{scale parameter, a positive number}

\item{Sigma}{scale matrix, a symmetric positive definite matrix, or
\code{NULL} for the identity matrix of order \code{p}}

\item{p}{if \code{Sigma} is \code{NULL}, this sets \code{Sigma} to the
identity matrix of order \code{p}; ignored if \code{Sigma} is not \code{NULL}}

\item{checkSymmetry}{logical, whether to check that \code{Sigma} is a
symmetric positive definite matrix}
}
\value{
A numeric three-dimensional array;
simulations are stacked along the third dimension.
}
\description{
Samples a matrix Gamma distribution.
}
\details{
This is the distribution of
\ifelse{html}{\out{&theta;/2&times;S}}{\eqn{\frac{\theta}{2}S}} where
\ifelse{html}{\out{S ~ W<sub>p</sub>(2&nu;,&Sigma;)}}{\eqn{S \sim \mathcal{W}_p(2\nu,\Sigma)}}.
}
\examples{
nu <- 3; theta <- 4; Sigma <- toeplitz(2:1)
Gsims <- rmatrixgamma(10000, nu, theta, Sigma)
apply(Gsims, c(1,2), mean) # should be nu * theta * Sigma
nu * theta * Sigma
}
\references{
Gupta & al.
Properties of Matrix Variate Confluent Hypergeometric Function Distribution.
\emph{Journal of Probability and Statistics}
vol. 2016, Article ID 2374907, 12 pages, 2016.
}
