% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matlab_script.R
\name{run_matlab_code}
\alias{run_matlab_code}
\title{Runs matlab code}
\usage{
run_matlab_code(code, endlines = TRUE, verbose = TRUE,
  add_clear_all = FALSE, paths_to_add = NULL, ...)
}
\arguments{
\item{code}{Character vector of code.}

\item{endlines}{Logical of whether the semicolon (;) should be
pasted to each element of the vector.}

\item{verbose}{Print out filename to run}

\item{add_clear_all}{Add \code{clear all;} to the beginning of code}

\item{paths_to_add}{Character vector of PATHs to add to the 
script using \code{\link{add_path}}}

\item{...}{Options passed to \code{\link{run_matlab_script}}}
}
\value{
Exit status of matlab code
}
\description{
This function takes in matlab code, where
the last line must end with a ;, and returns the exit
status
}
\examples{
if (have_matlab()){
   run_matlab_code(c("disp('The version of the matlab is:')", "disp(version)"),
   paths_to_add = "~/")
}
\dontrun{ 
if (have_matlab()){ 
   run_matlab_code("disp(version)")
   run_matlab_code("disp(version)", paths_to_add = "~/")
   run_matlab_code(c("x = 5", "disp(['The value of x is ', num2str(x)])"))
}
}
}
