% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result_option.R
\name{Ok}
\alias{Ok}
\title{Create an 'Ok' Result}
\usage{
Ok(x)
}
\arguments{
\item{x}{Object to be wrapped in the Enum variant.}
}
\value{
a list with a single value \code{x} and classes \code{"Result} and \code{"Enum}
}
\description{
Create an Enum variant of \code{Result} used to denote that function did not contain an error.
This allows the creation of safer functions.
}
\examples{
grepl_safe <- function(pattern, x)
{
  if (!is.character(pattern)){ return(Err("'pattern' in 'grepl_safe' was not a character value.")) }
  if (!is.character(x)){ return(Err("'x' in 'grepl_safe' was not a character value.")) }
  Ok(grepl(pattern, x))
}

#grepl_safe(123, 1:5)

}
