% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{shape}
\alias{shape}
\alias{shape.figure}
\title{Shape rule (Method)}
\usage{
shape(fig, n, rule, ...)

\method{shape}{figure}(fig, n = 1, rule = "shape", ...)
}
\arguments{
\item{fig}{A vector of figures obtained with the concatenation of figures function (cof()). Three figures are needed}

\item{n}{integer, the index of the element to see. Default is 1 (the first figure in cof() is shown). To see the other figures, change n to index the figure you want to show}

\item{rule}{character, defines the rule for shading the figure}

\item{...}{Other arguments}
}
\value{
An object of class figures, only the first figure is visible
}
\description{
Apply a change in figures rule by change the visibility of the shapes in a figure
}
\section{Methods (by class)}{
\itemize{
\item \code{shape(figure)}: Change the visible shapes

}}
\examples{
# Three figures, only the first is shown
draw(shape(cof(s_lily(), square(), s_star())))

# Show the third figure (star)
draw(shape(cof(s_lily(), square(), s_star()), n = 3))

# Show the first and the second figures
 draw(shape(cof(s_lily(), square(), s_star()), n = c(1,2)))
}
