% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/closed_figures.R
\name{pentagon}
\alias{pentagon}
\title{Coordinates of a pentagon}
\usage{
pentagon(
  size.x = 15,
  size.y = size.x,
  rot = pi/2,
  pos.x = 0,
  pos.y = 0,
  shd = NA,
  vis = 1,
  lty = 1,
  lwd = 3
)
}
\arguments{
\item{size.x}{numeric, define the semi-minor axis of the ellipse within which the figure is inscribed. Default is 15}

\item{size.y}{numeric, define the semi-minor axis of the ellipse within which the figure is inscribed. Default is size.x}

\item{rot}{define the rotation. Default is \eqn{\frac{\pi}{2}}}

\item{pos.x}{numeric, position on the x axis. Default is 0}

\item{pos.y}{numeric, position the y axis, Default is 0}

\item{shd}{character, define the shading of the figure. Default is NA which results in a transparent figure}

\item{vis}{Visibility of the figure. Default is 1, making the figure visible. To hide the figure, change it to 0}

\item{lty}{integer, define the line type of the figure, default is 1 (solid line).}

\item{lwd}{integer, define the line width of the figure. Default is 3}
}
\value{
Return the coordinates for drawing a pentagon
}
\description{
Define the coordinates for drawing a pentagon
}
\examples{
# return the default coordinates for drawing a pentagon
pentagon()
# change the coordinates for drawing a smaller pentagon
pentagon(size.x = 10)
}
