% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_figures.R
\name{maxi}
\alias{maxi}
\alias{s_maxi}
\title{Coordinates of a maxi}
\usage{
maxi(size.x = 8, size.y = 4, pos.x = 0, shd = NA, lty = 1, lwd = 3)

s_maxi(size.x = 8, size.y = 4, pos.x = 0, shd = NA, lty = 1, lwd = 3)
}
\arguments{
\item{size.x}{numeric, define the semi-major axis of the ellipse within which the figure is inscribed. Default is 8}

\item{size.y}{numeric, define the semi-minor axis of the ellipse within which the figure is inscribed. Default is 4}

\item{pos.x}{numeric, define the position on the x axis. Default is 0}

\item{shd}{character, define the color of the figure. Default is NA, which results in a transparent figure}

\item{lty}{integer, define the line type of the figure, default is 1 (solid line)}

\item{lwd}{integer, define the line width of the figure. Default is 3}
}
\value{
Return the coordinates for drawing a maxi

Return the coordinates for drawing a maxi
}
\description{
Define the coordinates for drawing a maxi (i.e., a cross composed of four lucks)
}
\section{Functions}{
\itemize{
\item \code{s_maxi()}: Coordinates of a single maxi

Define the coordinates for drawing a single maxi (i.e., a cross composed of four lucks), to be used in shape()

}}
\examples{
# return the default coordinates for drawing a maxi
maxi()
# change the coordinates for drawing a smaller maxi
maxi(size.x = 5)
# return the default coordinates for drawing a single maxi
s_maxi()
# change the coordinates for drawing a smaller single maxi
s_maxi(size.x = 5)
}
