% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{margin}
\alias{margin}
\alias{margin.figure}
\title{Margin rule (Method)}
\usage{
margin(fig, n, rule, ...)

\method{margin}{figure}(fig, n, rule, ...)
}
\arguments{
\item{fig}{The figure on which the rule is applied}

\item{n}{integer, defines the linetype of the linewidth}

\item{rule}{character, lty changes the linetype (1 = solid, 2 = dashed, 3 = dotted), lwd changes the linewdith}

\item{...}{Other arguments}
}
\value{
A figure with changed margins

A figure with changed margins
}
\description{
Apply a change in the margins of the figure
}
\section{Methods (by class)}{
\itemize{
\item \code{margin(figure)}: Change the margins rule

Apply a change in the margins of the figure

}}
\examples{
# draw default triangle
draw(triangle())

# change the linetype
draw(margin(triangle(), "lty", 2))
# draw default triangle
draw(triangle())

# change the linetype
draw(margin(triangle(),"lty", 2))
}
