% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizedError.R
\name{normalizedError}
\alias{normalizedError}
\title{Calculates normalized in balance verification using a mass standard}
\usage{
normalizedError(reading, standard, calibCert, u_massStandard = NULL)
}
\arguments{
\item{reading}{balance reading for the standard mass.}

\item{standard}{one of two options: an object of class \code{"massStandard"}
(see \code{\link[=massStandard]{massStandard()}}) or the numeric value of
the conventional mass of the standard used.}

\item{calibCert}{object of class \code{"calibCert"} with the calibration
data of the balance. See \code{\link[=calibCert]{calibCert()}} for details.}

\item{u_massStandard}{uncertainty of the conventional mass of the standard used.
Necessary only if \code{standard} is not an object of class
\code{"massStandard"} (see \code{\link[=massStandard]{massStandard()}}).}
}
\value{
Numeric value of normalized error for balance verification using a
mass standard.
}
\description{
Calculates normalized in balance verification using a mass standard
}
\examples{
data(E2.MS.20g)
data(MT.XPE.204)
normalizedError(reading = 20.0000, standard = E2.MS.20g, calibCert = MT.XPE.204)
}
\seealso{
\code{\link[=massStandard]{massStandard()}}.
}
