% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mars_main.r
\name{mars}
\alias{mars}
\title{Master mars function}
\usage{
mars(
  data,
  studyID,
  effectID,
  sample_size,
  effectsize_type = NULL,
  formula = NULL,
  variable_names = NULL,
  effectsize_name = NULL,
  estimation_method = "REML",
  variance = NULL,
  varcov_type,
  weights = NULL,
  structure = "UN",
  intercept = FALSE,
  missing = "remove",
  optim_method = "L-BFGS-B",
  robustID = NULL,
  multivariate_covs = NULL,
  tol = 1e-10,
  ...
)
}
\arguments{
\item{data}{Data used for analysis}

\item{studyID}{Character string representing the study ID}

\item{effectID}{Character string representing the effect size ID}

\item{sample_size}{Character string representing the sample size of the studies.}

\item{effectsize_type}{Type of effect size being analyzed}

\item{formula}{The formula used for specifying the fixed and random structure.
Used for univariate and multilevel structures.}

\item{variable_names}{Vector of character strings representing the attributes with
correlations. The attributes that are correlated should be separated by an
underscore.}

\item{effectsize_name}{Character string representing the name of the effect size
column in the data.}

\item{estimation_method}{Type of estimation used, either "REML" or "MLE", REML is the default}

\item{variance}{Character string representing the name of the variance of the effect size in the data.}

\item{varcov_type}{Type of variance covariance matrix computed. Default is
'cor_weighted' for correlations or 'smd_outcome' for standardized mean differences.}

\item{weights}{User specified matrix of weights for analysis.}

\item{structure}{Between studies covariance structure, default is "UN" or unstructured. See details for more specifics.}

\item{intercept}{Whether a model intercept should be specified, default is FALSE
meaning no intercept. See details for more information.}

\item{missing}{Whether missing data should be removed, or kept. Default is
removing.}

\item{optim_method}{Optimization method that is passed to the optim function.
Default is 'L-BFGS-B'.}

\item{robustID}{A character vector specifying the cluster group to use for computing the robust standard errors.}

\item{multivariate_covs}{A one-sided formula to specify the covariates used in a multivariate analysis.}

\item{tol}{Tolerance of the optimization, default is 1E-10.}

\item{...}{Not currently used.}
}
\value{
Returns a list of class mars; The returned object contains elements from the
estimation.
}
\description{
The primary function used for input and estimation. The function takes the
data inputs and routes the estimation and structure type based on data structure.
The function can handle univariate, multivariate, longitudinal, and multilevel meta-analytic models.
}
