% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_corr.r
\name{df_to_corr}
\alias{df_to_corr}
\title{Helper function to read in data}
\usage{
df_to_corr(data, variables, ID = NULL)
}
\arguments{
\item{data}{Data frame input used to convert to correlation matrices.}

\item{variables}{A character vector of variable names representing the columns
to convert to a pairwise correlation matrix. Variable names take the following format:
"columnname_rowname" where the name prior to the underscore is the column name and the
name after the underscore is the row name.}

\item{ID}{A variable name, as a character string, to use as names for the list elements.}
}
\value{
A list of correlation matrices.
}
\description{
This function builds a list of correlation matrices from data that are in
flat files where a correlation matrix is coded into a single row, a
common format for coding correlation matrices.
}
\examples{
becker09 <- read.csv(paste0(system.file('raw_data', package = 'mars'),
   '/Becker09.csv'))
becker09_list <- df_to_corr(becker09,
   variables = c('Cognitive_Performance',
                 'Somatic_Performance',
                 'Selfconfidence_Performance',
                 'Somatic_Cognitive',
                 'Selfconfidence_Cognitive',
                 'Selfconfidence_Somatic'),
    ID = 'ID')

}
