% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nas.R
\name{tableNA}
\alias{tableNA}
\title{Table NA values}
\usage{
tableNA(..., .list = FALSE)
}
\arguments{
\item{...}{one or more objects which can be interpreted as factors
    (including numbers or character strings), or a \code{\link[base]{list}} (such
    as a data frame) whose
    components can be so interpreted.  (For \code{as.table}, arguments
    passed to specific methods; for \code{as.data.frame}, unused.)}

\item{.list}{Logical, if \code{TRUE} and \code{...} is a \code{list}, will c}
}
\value{
\code{table()} returns a \emph{contingency table}, an object of
  class \code{"table"}, an array of integer values.
  Note that unlike S the result is always an \code{\link[base]{array}}, a 1D
  array if one factor is given.

  \code{as.table} and \code{is.table} coerce to and test for contingency
  table, respectively.

  The \code{as.data.frame} method for objects inheriting from class
  \code{"table"} can be used to convert the array-based representation
  of a contingency table to a data frame containing the classifying
  factors and the corresponding entries (the latter as component
  named by \code{responseName}).  This is the inverse of \code{\link{xtabs}}.
}
\description{
Tables out whether data are NAs are not
}
\details{
All data are checked with \code{is.na()} and the resulting \code{TRUE} or \code{FALSE} is
are tabulated.
}
\examples{
x <- list(
  a = c(1, 2, NA, 3),
  b = c("A", NA, "B", "C"),
  c = as.Date(c("2020-01-02", NA, NA, "2020-03-02"))
)
tableNA(x) # entire list
tableNA(x, .list = TRUE) # counts for each
tableNA(x[1], x[2])
tableNA(x[1], x[2], x[3]) # equivalent ot tableNA(x, .list = TRUE)
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988)
  \emph{The New S Language}.
  Wadsworth & Brooks/Cole.
}
\seealso{
\code{\link[base]{tabulate}} is the underlying function and allows finer
  control.

  Use \code{\link{ftable}} for printing (and more) of
  multidimensional tables.  \code{\link[base]{margin.table}},
  \code{\link[base]{prop.table}}, \code{\link{addmargins}}.

  \code{\link[base]{addNA}} for constructing factors with \code{\link[base]{NA}} as
  a level.

  \code{\link{xtabs}} for cross tabulation of data frames with a
  formula interface.
}
