% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.shiftfit.r
\name{plot.shiftfit}
\alias{plot.shiftfit}
\title{Plot results of an range-shift fit}
\usage{
\method{plot}{shiftfit}(x, ns = c(n.sims = 1000, n.times = 100, n.bins = 10),
  plot.ts = TRUE, stretch = 0, pt.cex = 0.8, pt.col = "antiquewhite",
  CI.cols = NULL, layout = NULL, par = NULL, ...)
}
\arguments{
\item{x}{a fitted range shift object, i.e. output of the \code{\link{estimate_shift}}}

\item{ns}{a vector of 3 simulation values, useful for smoothing the bars in the dumbbell plot.  For smoothing, it might be recommended to increase the first value, \code{n.sims} - the number of draws from the fitted migation process.}

\item{plot.ts}{whether or not to plot the time series as well}

\item{stretch}{an extra parameter to extend the bars on the dumbbells (in real distance units).}

\item{pt.cex}{point character expansion.}

\item{pt.col}{points color.}

\item{CI.cols}{three shading colors, from lightest to darkest. The default is a sequence of blues.}

\item{layout}{the default layout places the x-y plot on the left and - if \code{plot.ts==TRUE} - the respective 1-d time series on the right.}

\item{par}{graphics window parameters that, by default, look nice with the default layout.}

\item{...}{additional parameters to pass to plot function (e.g. labels, title, etc.)}
}
\description{
Plotting functions for illustrating the results of a range-shift fit.
}
\examples{
# load simulated tracks
data(SimulatedTracks)

# white noise fit
MWN.fit <- with(MWN.sim, estimate_shift(T=T, X=X, Y=Y))
summary(MWN.fit)
plot(MWN.fit)

if(interactive()){
# OUF fit
MOUF.fit <- with(MOUF.sim.random, 
                estimate_shift(T=T, X=X, Y=Y, 
                               model = "ouf", 
                               method = "like"))
summary(MOUF.fit)
plot(MOUF.fit)

# Three range fit:
# it is helpful to have some initital values for these parameters 
# because the automated quickfit() method is unreliable for three ranges
# in the example, we set a seed that seems to work
# set.seed(1976)

 MOU.3range.fit <- with(MOU.3range, 
                       estimate_shift(T=T, X=X, Y=Y, 
                                      model = "ou", 
                                      method = "ar", 
                                      n.clust = 3))
 summary(MOU.3range.fit)
 plot(MOU.3range.fit)
}
}
